<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Newsletter extends Model 
{

    protected $table = 'newsletters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function site()
    {
        return $this->belongsTo('App\Models\Newletter\Site');
    }

    public function automatisms()
    {
        return $this->hasMany('App\Models\Newletter\Automatism');
    }

}